USE Statistiche

DECLARE @ProdMultiplier DECIMAL(5,3) = 1.8

-- Moltiplicatore di cataloghi visti
DECLARE @CatMultiplier DECIMAL(5,3) = 1.8

-- Manufacturer ID
--DECLARE @ManufacturerID INT = '28,34,74,112,156,160,187,199,207,275,281,282,293,309,313,360,362,367,373,438,510,529,1286,1322,1456,1481,1598,1698,1743,1769,1777,1828,1994,2070,2093,2105,2216,2254,4000,4021,4100,4108,4114,4119,4145,4164'	-- tutti gli sponsor

-- primo giorno del mese iniziale
DECLARE @StartDate DATE = '2019-06-01'
-- ultimo giorno del mese finale
DECLARE @EndDate DATE = '2019-06-30'

BEGIN TRANSACTION

	--EXEC MAN_Recap @ManufacturerID, @StartDate, @EndDate,0

	UPDATE STS_ProductByDevice SET STS_ProductByDevice.PageViews = ROUND(STS_ProductByDevice.PageViews*@ProdMultiplier,0)
	FROM STS_ProductByDevice
		INNER JOIN ProductsFlatData ON STS_ProductByDevice.ProductID = ProductsFlatData.ProductID
	WHERE ProductsFlatData.ManufacturerID IN (28,34,74,112,156,160,187,199,207,275,281,282,293,309,313,360,362,367,373,438,510,529,1286,1322,1456,1481,1598,1698,1743,1769,1777,1828,1994,2070,2093,2105,2216,2254,4000,4021,4100,4108,4114,4119,4145,4164)
		AND STS_ProductByDevice.Data BETWEEN @StartDate AND @EndDate


	UPDATE STS_ProductByShopByDevice SET STS_ProductByShopByDevice.PageViews = ROUND(STS_ProductByShopByDevice.PageViews*@ProdMultiplier,0)
	FROM STS_ProductByShopByDevice
		INNER JOIN ProductsFlatData ON STS_ProductByShopByDevice.ProductID = ProductsFlatData.ProductID
	WHERE ProductsFlatData.ManufacturerID IN (28,34,74,112,156,160,187,199,207,275,281,282,293,309,313,360,362,367,373,438,510,529,1286,1322,1456,1481,1598,1698,1743,1769,1777,1828,1994,2070,2093,2105,2216,2254,4000,4021,4100,4108,4114,4119,4145,4164)
		AND STS_ProductByShopByDevice.Data BETWEEN @StartDate AND @EndDate

	
	UPDATE STS_ManufacturerByDevice SET CatalogPageViews = ROUND(CatalogPageViews*@CatMultiplier,0)
--		, Impressions = ROUND(Impressions*@ImpMultiplier,0)
	FROM STS_ManufacturerByDevice
	WHERE STS_ManufacturerByDevice.ManufacturerID IN (28,34,74,112,156,160,187,199,207,275,281,282,293,309,313,360,362,367,373,438,510,529,1286,1322,1456,1481,1598,1698,1743,1769,1777,1828,1994,2070,2093,2105,2216,2254,4000,4021,4100,4108,4114,4119,4145,4164)
		AND STS_ManufacturerByDevice.Data BETWEEN @StartDate AND @EndDate


	--------------------------------------------------------------------------------------------------------------
	---------------------------------- TROVAPRODOTTI -------------------------------------------------------------
	--------------------------------------------------------------------------------------------------------------

	UPDATE STS_ProductByTpByDevice SET STS_ProductByTpByDevice.PageViews = ROUND(STS_ProductByTpByDevice.PageViews*@ProdMultiplier,0)
	FROM STS_ProductByTpByDevice
		INNER JOIN ProductsFlatData ON STS_ProductByTpByDevice.ProductID = ProductsFlatData.ProductID
	WHERE ProductsFlatData.ManufacturerID IN (28,34,74,112,156,160,187,199,207,275,281,282,293,309,313,360,362,367,373,438,510,529,1286,1322,1456,1481,1598,1698,1743,1769,1777,1828,1994,2070,2093,2105,2216,2254,4000,4021,4100,4108,4114,4119,4145,4164)
		AND STS_ProductByTpByDevice.Data BETWEEN @StartDate AND @EndDate

	UPDATE STS_ManufacturerByTP SET PageViews = ROUND(PageViews*@CatMultiplier,0)
	FROM STS_ManufacturerByTP
	WHERE STS_ManufacturerByTP.ManufacturerID IN (28,34,74,112,156,160,187,199,207,275,281,282,293,309,313,360,362,367,373,438,510,529,1286,1322,1456,1481,1598,1698,1743,1769,1777,1828,1994,2070,2093,2105,2216,2254,4000,4021,4100,4108,4114,4119,4145,4164)
		AND STS_ManufacturerByTP.Data BETWEEN @StartDate AND @EndDate

	--EXEC MAN_Recap @ManufacturerID, @StartDate, @EndDate,0


COMMIT TRANSACTION