USE [Statistiche]

DECLARE @ProdMultiplier DECIMAL(5,3) = 3
-- Moltiplicatore di cataloghi visti
DECLARE @CatMultiplier DECIMAL(5,3) = 3

-- Manufacturer ID
DECLARE @ManufacturerID INT = 194	-- EMU

-- primo giorno del mese iniziale
DECLARE @StartDate DATE = '2020-08-01'
-- ultimo giorno del mese finale
DECLARE @EndDate DATE = '2020-08-31'

BEGIN TRANSACTION

	EXEC MAN_Recap @ManufacturerID, @StartDate, @EndDate,0

	UPDATE STS_ProductByDevice SET STS_ProductByDevice.PageViews = ROUND(STS_ProductByDevice.PageViews*@ProdMultiplier,0)
	FROM STS_ProductByDevice
		INNER JOIN ProductsFlatData ON STS_ProductByDevice.ProductID = ProductsFlatData.ProductID
	WHERE ProductsFlatData.ManufacturerID = @ManufacturerID AND STS_ProductByDevice.Data BETWEEN @StartDate AND @EndDate


	UPDATE STS_ProductByShopByDevice SET STS_ProductByShopByDevice.PageViews = ROUND(STS_ProductByShopByDevice.PageViews*@ProdMultiplier,0)
	FROM STS_ProductByShopByDevice
		INNER JOIN ProductsFlatData ON STS_ProductByShopByDevice.ProductID = ProductsFlatData.ProductID
	WHERE ProductsFlatData.ManufacturerID = @ManufacturerID AND STS_ProductByShopByDevice.Data BETWEEN @StartDate AND @EndDate

	
	UPDATE STS_ManufacturerByDevice SET CatalogPageViews = ROUND(CatalogPageViews*@CatMultiplier,0)
--		, Impressions = ROUND(Impressions*@ImpMultiplier,0)
	FROM STS_ManufacturerByDevice
	WHERE STS_ManufacturerByDevice.ManufacturerID = @ManufacturerID AND STS_ManufacturerByDevice.Data BETWEEN @StartDate AND @EndDate


	--------------------------------------------------------------------------------------------------------------
	---------------------------------- TROVAPRODOTTI -------------------------------------------------------------
	--------------------------------------------------------------------------------------------------------------

	UPDATE STS_ProductByTpByDevice SET STS_ProductByTpByDevice.PageViews = ROUND(STS_ProductByTpByDevice.PageViews*@ProdMultiplier,0)
	FROM STS_ProductByTpByDevice
		INNER JOIN ProductsFlatData ON STS_ProductByTpByDevice.ProductID = ProductsFlatData.ProductID
	WHERE ProductsFlatData.ManufacturerID = @ManufacturerID AND STS_ProductByTpByDevice.Data BETWEEN @StartDate AND @EndDate

	UPDATE STS_ManufacturerByTP SET PageViews = ROUND(PageViews*@CatMultiplier,0)
	FROM STS_ManufacturerByTP
	WHERE STS_ManufacturerByTP.ManufacturerID = @ManufacturerID AND STS_ManufacturerByTP.Data BETWEEN @StartDate AND @EndDate

	EXEC MAN_Recap @ManufacturerID, @StartDate, @EndDate,0


commit TRANSACTION